<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\Order;
use App\Models\Store;
use App\Models\Product;
use App\Models\Category;
use App\Models\ProductVariant;
use App\Models\Promotion;
use Illuminate\Foundation\Testing\RefreshDatabase;

class PublicRoutesTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function homepage_returns_200()
    {
        $response = $this->get('/');

        $response->assertStatus(200);
    }

    /** @test */
    public function products_page_returns_200()
    {
        $response = $this->get('/produits');

        $response->assertStatus(200);
    }

    /** @test */
    public function promotions_page_returns_200()
    {
        $response = $this->get('/promotions');

        $response->assertStatus(200);
    }

    /** @test */
    public function promotions_page_shows_active_promotions()
    {
        $active = Promotion::create([
            'title' => 'Promo Test Active',
            'description' => 'Description test',
            'start_date' => now()->subDay(),
            'end_date' => now()->addWeek(),
            'is_active' => true,
        ]);

        $inactive = Promotion::create([
            'title' => 'Promo Inactive',
            'description' => 'Description inactive',
            'start_date' => now()->subDay(),
            'end_date' => now()->addWeek(),
            'is_active' => false,
        ]);

        $response = $this->get('/promotions');

        $response->assertStatus(200);
        $response->assertSee('Promo Test Active');
        $response->assertDontSee('Promo Inactive');
    }

    /** @test */
    public function stores_page_returns_200()
    {
        $response = $this->get('/magasins');

        $response->assertStatus(200);
    }

    /** @test */
    public function confirmation_with_valid_uuid_returns_200()
    {
        $store = Store::create([
            'name' => 'Test Store',
            'street' => '123 Rue Test',
            'city' => 'Paris',
            'postal_code' => '75001',
            'phone' => '0123456789',
            'email' => 'store@test.com',
            'is_active' => true,
        ]);

        $order = Order::create([
            'order_number' => 'CMD-2026-00001',
            'uuid' => \Illuminate\Support\Str::uuid()->toString(),
            'customer_first_name' => 'Jean',
            'customer_last_name' => 'Dupont',
            'customer_phone' => '0600000000',
            'delivery_street' => '1 rue test',
            'store_id' => $store->id,
            'subtotal' => 100,
            'tax_amount' => 0,
            'shipping_cost' => 0,
            'total_amount' => 100,
            'status' => 'EN_ATTENTE_TRAITEMENT',
        ]);

        $response = $this->get('/commande/confirmation/' . $order->uuid);

        $response->assertStatus(200);
        $response->assertSee($order->order_number);
    }

    /** @test */
    public function confirmation_with_invalid_uuid_returns_404()
    {
        $response = $this->get('/commande/confirmation/uuid-inexistant-12345');

        $response->assertStatus(404);
    }
}
