

<?php $__env->startSection('title', 'Nos Matelas Orthopédiques - Jolis Matelas'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .products-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 48%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .products-page .page-header h1 {
        color: #003D82;
        text-align: center;
    }
    .products-page .page-header p {
        color: #475569;
        text-align: center;
    }
    .products-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .products-page .page-header nav a {
        color: #64748b;
    }
    .products-page .page-header nav span {
        color: #94a3b8;
    }
    .products-page .page-header nav a:hover {
        color: #003D82;
    }
    .products-page .btn {
        border-radius: 0.75rem;
        padding: 0.75rem 1.5rem;
        min-height: 2.75rem;
    }
    .products-page .btn-outline-gold {
        border: 1px solid #C9A65C;
        color: #C9A65C;
        background: transparent;
        font-weight: 600;
    }
    .products-page .btn-outline-gold:hover {
        background: rgba(201, 166, 92, 0.12);
        color: #9f7f36;
        border-color: #C9A65C;
    }
    .products-page .filters-panel {
        border-color: #e5e7eb;
        box-shadow: 0 12px 30px -24px rgba(15, 23, 42, 0.4);
    }
    .products-page .filter-group label {
        margin-bottom: 0.5rem;
    }
    .products-page .product-card-grid .card {
        border-color: #e5e7eb;
        box-shadow: 0 10px 25px -20px rgba(15, 23, 42, 0.4);
    }
    .products-page .product-card-grid .card:hover {
        transform: translateY(-2px);
    }
    .products-page .product-card-grid .aspect-square {
        aspect-ratio: 4 / 5;
    }
    .products-page .product-card-grid .btn {
        padding: 0.75rem 1.5rem;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 products-page">
    <?php echo $__env->make('partials.page-hero', [
        'title' => 'Nos Matelas Orthopédiques',
        'subtitle' => 'Découvrez notre sélection de matelas pour un sommeil sain et réparateur',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Produits']
        ]
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="flex flex-col lg:flex-row gap-10 items-start">
            <!-- Filters Sidebar -->
            <aside class="w-full lg:w-64 flex-shrink-0">
                <div class="filters-panel bg-white rounded-2xl shadow-sm p-6 sticky top-24 border border-gray-100">
                    <h3 class="font-semibold text-base mb-5 text-primary">Filtres</h3>

                    <form action="<?php echo e(route('products.index')); ?>" method="GET" id="filter-form" class="space-y-5">
                        <!-- Search -->
                        <div class="filter-group">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Rechercher</label>
                            <input type="text" name="search" value="<?php echo e($currentFilters['search'] ?? ''); ?>"
                                   class="input" placeholder="Nom du produit...">
                        </div>

                        <!-- Category -->
                        <?php if($categories->isNotEmpty()): ?>
                        <div class="filter-group">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Catégorie</label>
                            <select name="category" class="select">
                                <option value="">Toutes</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e(($currentFilters['category'] ?? '') == $category->id ? 'selected' : ''); ?>>
                                        <?php echo e($category->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php endif; ?>

                        <!-- Type -->
                        <?php if($types->isNotEmpty()): ?>
                        <div class="filter-group">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Type</label>
                            <select name="type" class="select">
                                <option value="">Tous</option>
                                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type); ?>" <?php echo e(($currentFilters['type'] ?? '') == $type ? 'selected' : ''); ?>>
                                        <?php echo e(config('shop.product_type_labels')[$type] ?? $type); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php endif; ?>

                        <!-- Firmness -->
                        <?php if($firmnesses->isNotEmpty()): ?>
                        <div class="filter-group">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Fermeté</label>
                            <select name="firmness" class="select">
                                <option value="">Toutes</option>
                                <?php $__currentLoopData = $firmnesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $firmness): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($firmness); ?>" <?php echo e(($currentFilters['firmness'] ?? '') == $firmness ? 'selected' : ''); ?>>
                                        <?php echo e(config('shop.product_firmness_labels')[$firmness] ?? $firmness); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php endif; ?>

                        <!-- Sort -->
                        <div class="filter-group">
                            <label class="block text-sm font-medium text-gray-600 mb-2">Trier par</label>
                            <select name="sort" class="select">
                                <option value="newest" <?php echo e(($currentFilters['sort'] ?? 'newest') == 'newest' ? 'selected' : ''); ?>>Plus récents</option>
                                <option value="price_asc" <?php echo e(($currentFilters['sort'] ?? '') == 'price_asc' ? 'selected' : ''); ?>>Prix croissant</option>
                                <option value="price_desc" <?php echo e(($currentFilters['sort'] ?? '') == 'price_desc' ? 'selected' : ''); ?>>Prix décroissant</option>
                                <option value="name" <?php echo e(($currentFilters['sort'] ?? '') == 'name' ? 'selected' : ''); ?>>Nom A-Z</option>
                            </select>
                        </div>

                        <div class="mt-6 flex flex-col gap-3">
                            <button type="submit" class="btn bg-primary text-white w-full hover:bg-primary/90">
                                Appliquer
                            </button>

                            <?php if(array_filter($currentFilters)): ?>
                            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-gold w-full inline-flex items-center justify-center">
                                Réinitialiser
                            </a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </aside>

            <!-- Products Grid -->
            <div class="flex-1">
                <?php if($products->isEmpty()): ?>
                    <div class="text-center py-16 bg-white rounded-2xl border border-gray-100">
                        <i data-lucide="package-x" class="h-16 w-16 mx-auto text-gray-300 mb-4"></i>
                        <h3 class="text-lg font-medium text-gray-900 mb-2">Aucun produit trouvé</h3>
                        <p class="text-gray-500">Essayez de modifier vos filtres</p>
                    </div>
                <?php else: ?>
                    <div class="product-card-grid grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-3 gap-6">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo $__env->make('partials.product-card', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-10 flex justify-center">
                        <?php echo e($products->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/products/index.blade.php ENDPATH**/ ?>