﻿

<?php $__env->startSection('title', 'Nos Promotions - Jolis Matelas'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .promotions-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 50%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .promotions-page .page-header h1 {
        color: #003D82;
        text-align: center;
    }
    .promotions-page .page-header p {
        color: #475569;
        text-align: center;
    }
    .promotions-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .promotions-page .page-header nav a {
        color: #64748b;
    }
    .promotions-page .page-header nav span {
        color: #94a3b8;
    }
    .promotions-page .page-header nav a:hover {
        color: #003D82;
    }
    .promotions-page .promo-card {
        border: 1px solid #e5e7eb;
        box-shadow: 0 12px 30px -24px rgba(15, 23, 42, 0.4);
    }
    .promotions-page .promo-card:hover {
        transform: translateY(-2px);
    }
    .promotions-page .promo-image {
        aspect-ratio: 16 / 9;
    }
    .promotions-page .promo-description {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .promotions-page .promo-cta {
        border-radius: 0.75rem;
        padding: 0.65rem 1.4rem;
        border: 1px solid #C9A65C;
        color: #C9A65C;
        font-weight: 600;
    }
    .promotions-page .promo-cta:hover {
        background: rgba(201, 166, 92, 0.12);
        color: #9f7f36;
        border-color: #C9A65C;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 promotions-page">
    <?php echo $__env->make('partials.page-hero', [
        'title' => 'Nos Promotions',
        'subtitle' => 'Profitez de nos offres sur une large gamme de matelas',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Promotions']
        ]
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <?php if($promotions->isEmpty()): ?>
            <div class="text-center py-16 bg-white rounded-2xl border border-gray-100">
                <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="tag" class="h-8 w-8 text-gray-300"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucune promotion en cours</h3>
                <p class="text-gray-500 mb-6">Revenez bientôt pour découvrir nos nouvelles offres.</p>
                <a href="<?php echo e(route('products.index')); ?>" class="btn bg-primary text-white hover:bg-primary/90">
                    Voir nos produits
                </a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $promotions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $promo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card promo-card overflow-hidden transition-all bg-white flex flex-col">
                    <div class="promo-image w-full overflow-hidden bg-gray-100">
                        <?php if($promo->image_path): ?>
                            <img src="<?php echo e(asset('storage/' . $promo->image_path)); ?>" alt="<?php echo e($promo->title); ?>" class="w-full h-full object-cover">
                        <?php else: ?>
                            <img src="<?php echo e(asset('images/placeholder.jpg')); ?>" alt="Promotion JOLI Matelas" class="w-full h-full object-cover opacity-80">
                        <?php endif; ?>
                    </div>
                    <div class="p-6 flex flex-col flex-1">
                        <div class="flex items-start justify-between mb-4">
                            <div>
                                <span class="badge bg-accent/10 text-accent mb-2">PROMO</span>
                                <h3 class="font-semibold text-lg text-gray-900"><?php echo e($promo->title); ?></h3>
                            </div>
                            <div class="h-10 w-10 bg-accent/10 rounded-full flex items-center justify-center flex-shrink-0">
                                <i data-lucide="tag" class="h-5 w-5 text-accent"></i>
                            </div>
                        </div>

                        <p class="promo-description text-gray-500 text-sm mb-5"><?php echo e($promo->description); ?></p>

                        <div class="mt-auto flex items-center justify-between pt-4 border-t border-gray-100">
                            <span class="text-sm text-gray-400">Offre valable selon disponibilité en magasin.</span>
                            <a href="<?php echo e(route('products.index')); ?>" class="promo-cta inline-flex items-center justify-center text-sm">
                                Voir les produits
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/promotions/index.blade.php ENDPATH**/ ?>