<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion Admin - JOLI Matelas</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#003D82',
                        accent: '#C9A65C',
                    }
                }
            }
        }
    </script>
    <script src="https://unpkg.com/lucide@latest"></script>
</head>
<body class="bg-gradient-to-br from-primary via-blue-800 to-primary min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <!-- Logo -->
        <div class="text-center mb-8">
            <div class="flex items-center justify-center mx-auto mb-4">
                <img src="<?php echo e(asset('images/logo.jpg')); ?>" alt="JOLI Matelas" class="h-16 w-auto rounded-lg">
            </div>
            <h1 class="text-3xl font-bold text-white mb-2">JOLI Matelas</h1>
            <p class="text-blue-200">Administration</p>
        </div>

        <!-- Login Form -->
        <div class="bg-white rounded-2xl shadow-2xl p-8">
            <?php if(session('error')): ?>
            <div class="mb-6 p-4 bg-red-50 border border-red-200 text-red-700 rounded-lg flex items-center gap-2">
                <i data-lucide="alert-circle" class="h-5 w-5"></i>
                <span><?php echo e(session('error')); ?></span>
            </div>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.login')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i data-lucide="mail" class="h-4 w-4 inline mr-1"></i>
                        Adresse email
                    </label>
                    <input type="email" name="email" required autofocus
                           value="<?php echo e(old('email')); ?>"
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-primary outline-none transition"
                           placeholder="admin@joli.ma">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i data-lucide="lock" class="h-4 w-4 inline mr-1"></i>
                        Mot de passe
                    </label>
                    <input type="password" name="password" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-primary outline-none transition"
                           placeholder="••••••••">
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <button type="submit"
                        class="w-full bg-primary hover:bg-blue-900 text-white font-medium py-3 px-6 rounded-lg transition-colors flex items-center justify-center gap-2">
                    <i data-lucide="log-in" class="h-5 w-5"></i>
                    Se connecter
                </button>
            </form>

            <div class="mt-6 pt-6 border-t text-center">
                <a href="<?php echo e(route('home')); ?>" class="text-sm text-gray-600 hover:text-primary flex items-center justify-center gap-2">
                    <i data-lucide="arrow-left" class="h-4 w-4"></i>
                    Retour au site
                </a>
            </div>
        </div>

        <p class="text-center text-blue-200 text-sm mt-6">
            © <?php echo e(date('Y')); ?> JOLI Matelas. Tous droits réservés.
        </p>
    </div>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>
<?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>