<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['product']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['product']); ?>
<?php foreach (array_filter((['product']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    $image = $product->images[0] ?? null;
    $imageUrl = $image ? (str_starts_with($image, 'http') ? $image : asset('storage/' . $image)) : asset('images/placeholder.jpg');
    $minPrice = $product->variants->min('price') ?? $product->base_price;
    $typeLabels = config('shop.product_type_labels', []);
?>

<div class="group card hover:shadow-md hover:-translate-y-0.5 flex flex-col">
    <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="block flex-1">
        <!-- Image -->
        <div class="relative aspect-square overflow-hidden bg-gray-100 rounded-t-2xl">
            <img
                src="<?php echo e($imageUrl); ?>"
                alt="<?php echo e($product->name); ?>"
                class="object-cover w-full h-full group-hover:scale-105 transition-transform duration-300"
                loading="lazy"
            />
        </div>

        <!-- Content -->
        <div class="p-6">
            <div class="text-xs text-gray-400 uppercase tracking-wide mb-2">
                <?php echo e($typeLabels[$product->type] ?? $product->type); ?>

            </div>
            <h3 class="font-semibold text-base mb-3 text-gray-900 group-hover:text-primary transition-colors line-clamp-2">
                <?php echo e($product->name); ?>

            </h3>
            <span class="text-lg font-bold text-primary">
                À partir de <?php echo e(number_format($minPrice, 0, ',', ' ')); ?> <?php echo e(config('shop.currency_symbol', 'XAF')); ?>

            </span>
        </div>
    </a>

    <!-- Action -->
    <div class="px-6 pb-6 mt-auto flex justify-center product-card-cta">
        <a href="<?php echo e(route('products.show', $product->slug)); ?>"
           class="btn bg-primary text-white hover:bg-primary/90 inline-flex px-6 py-3 rounded-xl gap-2">
            Voir & Commander
            <i data-lucide="arrow-right" class="h-4 w-4"></i>
        </a>
    </div>
</div>
<?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/partials/product-card.blade.php ENDPATH**/ ?>