<?php $__env->startSection('title', 'Services connexes - JOLI Matelas'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .services-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 52%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .services-page .page-header h1,
    .services-page .page-header p {
        text-align: center;
    }
    .services-page .page-header h1 {
        color: #003D82;
    }
    .services-page .page-header p {
        color: #475569;
    }
    .services-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .services-page .page-header nav a {
        color: #64748b;
    }
    .services-page .page-header nav span {
        color: #94a3b8;
    }
    .services-page .page-header nav a:hover {
        color: #003D82;
    }
    .services-page .services-grid {
        max-width: 72rem;
        margin-left: auto;
        margin-right: auto;
    }
    .services-page .service-card {
        border: 1px solid #e5e7eb;
        box-shadow: 0 12px 30px -24px rgba(15, 23, 42, 0.4);
    }
    .services-page .service-card:hover {
        transform: translateY(-2px);
    }
    .services-page .service-image {
        aspect-ratio: 16 / 10;
    }
    .services-page .service-title {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .services-page .service-description {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .services-page .service-description .hashtag {
        display: none;
    }
    .services-page .service-cta {
        border-radius: 0.75rem;
        padding: 0.65rem 1.4rem;
        border: 1px solid #C9A65C;
        color: #C9A65C;
        font-weight: 600;
    }
    .services-page .service-cta:hover {
        background: rgba(201, 166, 92, 0.12);
        color: #9f7f36;
    }
    .services-page .cta-panel {
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 100%);
        border: 1px solid #e5e7eb;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 services-page">
    <?php echo $__env->make('partials.page-hero', [
        'title' => 'Services connexes',
        'subtitle' => 'Des services pensés pour mieux vous accompagner',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Services connexes']
        ]
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <?php if($services->isEmpty()): ?>
            <div class="text-center py-16 bg-white rounded-2xl shadow-sm border border-gray-100">
                <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="briefcase" class="h-8 w-8 text-gray-300"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucun service disponible</h3>
                <p class="text-gray-500 mb-6">Revenez bientôt pour découvrir nos services.</p>
                <a href="<?php echo e(route('contact')); ?>" class="btn btn-default">Nous contacter</a>
            </div>
        <?php else: ?>
            <div class="services-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $cleanDescription = trim(preg_replace('/#[\\p{L}0-9_]+/u', '', $service->description));
                    ?>
                    <div class="card service-card overflow-hidden transition-all bg-white flex flex-col">
                        <div class="service-image w-full overflow-hidden bg-gray-100">
                            <?php if($service->image): ?>
                                <img src="<?php echo e(asset('storage/' . $service->image)); ?>" alt="<?php echo e($service->title); ?>" class="h-full w-full object-cover">
                            <?php else: ?>
                                <img src="<?php echo e(asset('images/placeholder.jpg')); ?>" alt="Service JOLI Matelas" class="h-full w-full object-cover opacity-80">
                            <?php endif; ?>
                        </div>
                        <div class="p-5 flex flex-col flex-1 gap-3">
                            <h2 class="service-title text-lg font-semibold text-primary"><?php echo e($service->title); ?></h2>
                            <p class="service-description text-sm text-gray-600 leading-relaxed"><?php echo e($cleanDescription); ?></p>
                            <div class="pt-1">
                                <a href="<?php echo e(route('contact')); ?>" class="service-cta inline-flex items-center justify-center text-sm">
                                    Nous contacter
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <div class="mt-12">
            <div class="cta-panel rounded-2xl px-6 py-10 text-center">
                <h2 class="text-2xl font-bold text-primary mb-3 font-display">Besoin d’un service ?</h2>
                <p class="text-gray-600 mb-6">Nos équipes vous répondent rapidement pour vous guider.</p>
                <a href="<?php echo e(route('contact')); ?>" class="btn btn-default btn-lg">
                    Contactez-nous
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/services/index.blade.php ENDPATH**/ ?>