﻿

<?php $__env->startSection('title', 'Modifier une promotion'); ?>
<?php $__env->startSection('page-title', 'Promotions'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Modifier une promotion</h2>
        <a href="<?php echo e(route('admin.promotions.index')); ?>" class="text-sm text-gray-600 hover:text-primary">Retour</a>
    </div>

    <?php if($errors->any()): ?>
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('admin.promotions.update', $promotion->id)); ?>" enctype="multipart/form-data" class="space-y-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div class="lg:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-2">Titre *</label>
                <input type="text" name="title" value="<?php echo e(old('title', $promotion->title)); ?>" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div class="lg:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-2">Description *</label>
                <textarea name="description" rows="4" required
                          class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm"><?php echo e(old('description', $promotion->description)); ?></textarea>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Image</label>
                <input type="file" name="image" accept="image/*"
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
                <?php if($promotion->image_path): ?>
                    <div class="mt-2">
                        <img src="<?php echo e(asset('storage/' . $promotion->image_path)); ?>" alt="<?php echo e($promotion->title); ?>" class="h-16 w-24 object-cover rounded">
                    </div>
                <?php endif; ?>
            </div>

            <div class="flex items-center">
                <label class="inline-flex items-center gap-3">
                    <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $promotion->is_active) ? 'checked' : ''); ?>

                           class="h-4 w-4 rounded border-gray-300 text-primary">
                    <span class="text-sm text-gray-700">Promotion active</span>
                </label>
            </div>
        </div>

        <div class="flex items-center justify-end gap-3">
            <a href="<?php echo e(route('admin.promotions.index')); ?>"
               class="px-4 py-2 text-sm text-gray-600 hover:text-primary">Annuler</a>
            <button type="submit"
                    class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90">Enregistrer</button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/admin/promotions/edit.blade.php ENDPATH**/ ?>