<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin'); ?> - JOLI Matelas</title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#003D82',
                        secondary: '#4A90E2',
                        accent: '#C9A65C',
                    }
                }
            }
        }
    </script>

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        [x-cloak] { display: none !important; }
        .spinner { width: 20px; height: 20px; border: 2px solid #fff; border-top-color: transparent; border-radius: 50%; animation: spin 0.8s linear infinite; }
        @keyframes spin { to { transform: rotate(360deg); } }
    </style>
</head>
<body class="bg-gray-100 min-h-screen" x-data="{ sidebarOpen: true, mobileMenuOpen: false }">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <aside :class="sidebarOpen ? 'w-64' : 'w-20'"
               class="hidden lg:flex flex-col bg-primary text-white transition-all duration-300">
            <!-- Logo -->
            <div class="p-4 border-b border-white/10">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center gap-3">
                    <img src="<?php echo e(asset('images/logo.jpg')); ?>" alt="JOLI Matelas" class="h-10 w-auto rounded">
                    <span x-show="sidebarOpen" x-transition class="font-bold text-xl">JOLI Admin</span>
                </a>
            </div>

            <!-- Navigation -->
            <nav class="flex-1 overflow-y-auto py-4">
                <ul class="space-y-1 px-3">
                    <li>
                        <a href="<?php echo e(route('admin.dashboard')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="layout-dashboard" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Dashboard</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.orders.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.orders.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="shopping-cart" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Commandes</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.categories.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.categories.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="folder" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Categories</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.product-attributes.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.product-attributes.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="sliders-horizontal" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Attributs Produits</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.products.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.products.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="package" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Produits</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.services.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.services.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="briefcase" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Services connexes</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.stock.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.stock.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="warehouse" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Stock</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.stock.movements.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.stock.movements.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="activity" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Mouvements de stock</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.stock.inventories.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.stock.inventories.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="clipboard-list" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Inventaires</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.stores.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.stores.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="store" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Magasins</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.users.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.users.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="users" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Utilisateurs</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.promotions.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.promotions.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="tag" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Promotions</span>
                        </a>
                    </li>
                    <li class="pt-4 mt-4 border-t border-white/10">
                        <a href="<?php echo e(route('admin.settings.index')); ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors <?php echo e(request()->routeIs('admin.settings.*') ? 'bg-white/20' : ''); ?>">
                            <i data-lucide="settings" class="h-5 w-5"></i>
                            <span x-show="sidebarOpen" x-transition>Parametres</span>
                        </a>
                    </li>
                </ul>
            </nav>

            <!-- Toggle Button -->
            <div class="p-4 border-t border-white/10">
                <button @click="sidebarOpen = !sidebarOpen"
                        class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10 transition-colors w-full">
                    <i data-lucide="panel-left-close" x-show="sidebarOpen" class="h-5 w-5"></i>
                    <i data-lucide="panel-left-open" x-show="!sidebarOpen" class="h-5 w-5"></i>
                    <span x-show="sidebarOpen" x-transition>Réduire</span>
                </button>
            </div>
        </aside>

        <!-- Mobile Sidebar -->
        <div x-show="mobileMenuOpen" x-cloak
             class="lg:hidden fixed inset-0 z-50">
            <div class="absolute inset-0 bg-black/50" @click="mobileMenuOpen = false"></div>
            <aside class="absolute left-0 top-0 bottom-0 w-64 bg-primary text-white">
                <div class="p-4 border-b border-white/10 flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <img src="<?php echo e(asset('images/logo.jpg')); ?>" alt="JOLI Matelas" class="h-8 w-auto rounded">
                        <span class="font-bold text-xl">JOLI Admin</span>
                    </div>
                    <button @click="mobileMenuOpen = false" class="p-2">
                        <i data-lucide="x" class="h-5 w-5"></i>
                    </button>
                </div>
                <nav class="py-4">
                    <ul class="space-y-1 px-3">
                        <li><a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="layout-dashboard" class="h-5 w-5"></i>Dashboard</a></li>
                        <li><a href="<?php echo e(route('admin.orders.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="shopping-cart" class="h-5 w-5"></i>Commandes</a></li>
                        <li><a href="<?php echo e(route('admin.categories.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="folder" class="h-5 w-5"></i>Catégories</a></li>
                        <li><a href="<?php echo e(route('admin.product-attributes.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="sliders-horizontal" class="h-5 w-5"></i>Attributs Produits</a></li>
                        <li><a href="<?php echo e(route('admin.products.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="package" class="h-5 w-5"></i>Produits</a></li>
                        <li><a href="<?php echo e(route('admin.services.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="briefcase" class="h-5 w-5"></i>Services connexes</a></li>
                        <li><a href="<?php echo e(route('admin.stock.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="warehouse" class="h-5 w-5"></i>Stock</a></li>
                        <li><a href="<?php echo e(route('admin.stock.movements.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="activity" class="h-5 w-5"></i>Mouvements de stock</a></li>
                        <li><a href="<?php echo e(route('admin.stock.inventories.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="clipboard-list" class="h-5 w-5"></i>Inventaires</a></li>
                        <li><a href="<?php echo e(route('admin.stores.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="store" class="h-5 w-5"></i>Magasins</a></li>
                        <li><a href="<?php echo e(route('admin.users.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="users" class="h-5 w-5"></i>Utilisateurs</a></li>
                        <li><a href="<?php echo e(route('admin.promotions.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="tag" class="h-5 w-5"></i>Promotions</a></li>
                        <li><a href="<?php echo e(route('admin.settings.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg hover:bg-white/10"><i data-lucide="settings" class="h-5 w-5"></i>Paramètres</a></li>
                    </ul>
                </nav>
            </aside>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Bar -->
            <header class="bg-white shadow-sm h-16 flex items-center px-4 lg:px-6">
                <button @click="mobileMenuOpen = true" class="lg:hidden p-2 mr-4">
                    <i data-lucide="menu" class="h-6 w-6"></i>
                </button>

                <h1 class="text-xl font-bold text-primary"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h1>

                <div class="ml-auto flex items-center gap-4">
                    <a href="<?php echo e(route('home')); ?>" target="_blank" class="text-gray-600 hover:text-primary">
                        <i data-lucide="external-link" class="h-5 w-5"></i>
                    </a>
                    <?php if(auth()->guard()->check()): ?>
                    <div class="flex items-center gap-2">
                        <span class="text-sm text-gray-600"><?php echo e(auth()->user()->first_name); ?></span>
                        <form action="<?php echo e(route('admin.logout')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="text-gray-600 hover:text-red-600">
                                <i data-lucide="log-out" class="h-5 w-5"></i>
                            </button>
                        </form>
                    </div>
                    <?php endif; ?>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-4 lg:p-6">
                <?php if(session('success')): ?>
                <div class="mb-4 p-4 bg-green-50 border border-green-200 text-green-700 rounded-lg flex items-center gap-2">
                    <i data-lucide="check-circle" class="h-5 w-5"></i>
                    <?php echo e(session('success')); ?>

                </div>
                <?php endif; ?>

                <?php if(session('warning')): ?>
                <div class="mb-4 p-4 bg-amber-50 border border-amber-200 text-amber-700 rounded-lg flex items-center gap-2">
                    <i data-lucide="alert-triangle" class="h-5 w-5"></i>
                    <?php echo e(session('warning')); ?>

                </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                <div class="mb-4 p-4 bg-red-50 border border-red-200 text-red-700 rounded-lg flex items-center gap-2">
                    <i data-lucide="alert-circle" class="h-5 w-5"></i>
                    <?php echo e(session('error')); ?>

                </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>
<?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/layouts/admin.blade.php ENDPATH**/ ?>