@extends('layouts.app')

@section('title', 'Nos Magasins - Jolis Matelas')

@push('styles')
<style>
    .stores-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 52%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .stores-page .page-header h1,
    .stores-page .page-header p {
        text-align: center;
    }
    .stores-page .page-header h1 {
        color: #003D82;
    }
    .stores-page .page-header p {
        color: #475569;
    }
    .stores-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .stores-page .page-header nav a {
        color: #64748b;
    }
    .stores-page .page-header nav span {
        color: #94a3b8;
    }
    .stores-page .page-header nav a:hover {
        color: #003D82;
    }
    .stores-page .stores-grid {
        max-width: 72rem;
        margin-left: auto;
        margin-right: auto;
    }
    .stores-page .store-card {
        border: 1px solid #e5e7eb;
        box-shadow: 0 12px 30px -24px rgba(15, 23, 42, 0.4);
    }
    .stores-page .store-card:hover {
        transform: translateY(-2px);
    }
    .stores-page .store-actions {
        display: grid;
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    @media (min-width: 640px) {
        .stores-page .store-actions {
            grid-template-columns: repeat(2, minmax(0, 1fr));
        }
    }
    .stores-page .store-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        width: 100%;
        padding: 0.75rem 1rem;
        border-radius: 0.75rem;
        font-weight: 600;
    }
    .stores-page .store-btn-primary {
        background: #003D82;
        color: #ffffff;
    }
    .stores-page .store-btn-primary:hover {
        background: #00356f;
    }
    .stores-page .store-btn-outline {
        border: 1px solid #C9A65C;
        color: #C9A65C;
    }
    .stores-page .store-btn-outline:hover {
        background: rgba(201, 166, 92, 0.12);
        color: #9f7f36;
    }
    .stores-page .store-muted {
        color: #94a3b8;
    }
</style>
@endpush

@section('content')
<div class="min-h-screen bg-gray-50 stores-page">
    @include('partials.page-hero', [
        'title' => 'Nos Magasins',
        'subtitle' => 'Trouvez le magasin Jolis Matelas le plus proche de chez vous',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Magasins']
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
        @if($stores->isEmpty())
            <div class="text-center py-16 bg-white rounded-2xl border border-gray-100">
                <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="store" class="h-8 w-8 text-gray-300"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucun magasin disponible</h3>
                <p class="text-gray-500">Revenez bientôt !</p>
            </div>
        @else
            <div class="stores-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($stores as $store)
                <div class="card store-card overflow-hidden transition-all bg-white">
                    <div class="p-6 flex flex-col h-full">
                        <div class="flex items-start justify-between mb-4">
                            <div>
                                <h3 class="text-xl font-bold text-primary">{{ $store->name }}</h3>
                                <p class="text-gray-500">{{ $store->city ?? '—' }}</p>
                            </div>
                            <div class="h-10 w-10 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                                <i data-lucide="store" class="h-5 w-5 text-primary"></i>
                            </div>
                        </div>

                        @if($store->description)
                        <p class="text-sm text-gray-500 mb-4">{{ $store->description }}</p>
                        @endif

                        <div class="space-y-3">
                            <!-- Address -->
                            @if($store->street || $store->postal_code || $store->city)
                            <div class="flex items-start gap-3">
                                <i data-lucide="map-pin" class="h-4 w-4 text-accent flex-shrink-0 mt-0.5"></i>
                                <div class="text-sm text-gray-600">
                                    @if($store->street)
                                        <p>{{ $store->street }}</p>
                                    @endif
                                    <p>
                                        {{ $store->postal_code ?? '' }}
                                        {{ $store->city ?? '' }}
                                    </p>
                                </div>
                            </div>
                            @endif

                            <!-- Phone -->
                            @if($store->phone)
                            <div class="flex items-center gap-3">
                                <i data-lucide="phone" class="h-4 w-4 text-accent flex-shrink-0"></i>
                                <a href="tel:{{ $store->phone }}" class="text-sm text-gray-600 hover:text-primary transition-colors">
                                    {{ $store->phone }}
                                </a>
                            </div>
                            @endif

                            <!-- Email -->
                            @if($store->email)
                            <div class="flex items-center gap-3">
                                <i data-lucide="mail" class="h-4 w-4 text-accent flex-shrink-0"></i>
                                <a href="mailto:{{ $store->email }}" class="text-sm text-gray-600 hover:text-primary transition-colors">
                                    {{ $store->email }}
                                </a>
                            </div>
                            @endif

                            <!-- Opening Hours -->
                            @if($store->opening_hours)
                            <div class="flex items-start gap-3">
                                <i data-lucide="clock" class="h-4 w-4 text-accent flex-shrink-0 mt-0.5"></i>
                                <div class="text-sm text-gray-600">
                                    @foreach($store->opening_hours as $day => $hours)
                                    <p><span class="font-medium">{{ $day }} :</span> {{ $hours }}</p>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                        </div>

                        <!-- Actions -->
                        <div class="mt-6 pt-4 border-t border-gray-100 store-actions">
                            @if($store->latitude && $store->longitude)
                            <a href="https://www.google.com/maps?q={{ $store->latitude }},{{ $store->longitude }}"
                               target="_blank" rel="noopener noreferrer"
                               class="store-btn store-btn-outline text-sm">
                                <i data-lucide="navigation" class="h-4 w-4"></i>
                                Itinéraire
                            </a>
                            @endif
                            @if($store->phone)
                            <a href="tel:{{ $store->phone }}"
                               class="store-btn store-btn-primary text-sm">
                                <i data-lucide="phone" class="h-4 w-4"></i>
                                Appeler le magasin
                            </a>
                            @else
                            <div class="store-btn store-btn-outline text-sm store-muted">
                                Téléphone indisponible
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        @endif
    </div>
</div>
@endsection
