@props(['product'])

@php
    $image = $product->images[0] ?? null;
    $imageUrl = $image ? (str_starts_with($image, 'http') ? $image : asset('storage/' . $image)) : asset('images/placeholder.jpg');
    $minPrice = $product->variants->min('price') ?? $product->base_price;
    $typeLabels = config('shop.product_type_labels', []);
@endphp

<div class="group card hover:shadow-md hover:-translate-y-0.5 flex flex-col">
    <a href="{{ route('products.show', $product->slug) }}" class="block flex-1">
        <!-- Image -->
        <div class="relative aspect-square overflow-hidden bg-gray-100 rounded-t-2xl">
            <img
                src="{{ $imageUrl }}"
                alt="{{ $product->name }}"
                class="object-cover w-full h-full group-hover:scale-105 transition-transform duration-300"
                loading="lazy"
            />
        </div>

        <!-- Content -->
        <div class="p-6">
            <div class="text-xs text-gray-400 uppercase tracking-wide mb-2">
                {{ $typeLabels[$product->type] ?? $product->type }}
            </div>
            <h3 class="font-semibold text-base mb-3 text-gray-900 group-hover:text-primary transition-colors line-clamp-2">
                {{ $product->name }}
            </h3>
            <span class="text-lg font-bold text-primary">
                À partir de {{ number_format($minPrice, 0, ',', ' ') }} {{ config('shop.currency_symbol', 'XAF') }}
            </span>
        </div>
    </a>

    <!-- Action -->
    <div class="px-6 pb-6 mt-auto flex justify-center product-card-cta">
        <a href="{{ route('products.show', $product->slug) }}"
           class="btn bg-primary text-white hover:bg-primary/90 inline-flex px-6 py-3 rounded-xl gap-2">
            Voir & Commander
            <i data-lucide="arrow-right" class="h-4 w-4"></i>
        </a>
    </div>
</div>
