@props([
    'title',
    'subtitle' => null,
    'breadcrumbs' => []
])

<section class="page-header">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        @if(!empty($breadcrumbs))
            <nav class="mb-3 text-sm text-white/70" aria-label="Breadcrumb">
                <ol class="flex flex-wrap items-center gap-2">
                    @foreach($breadcrumbs as $crumb)
                        <li class="flex items-center gap-2">
                            @if(!empty($crumb['href']))
                                <a href="{{ $crumb['href'] }}" class="hover:text-white transition-colors">
                                    {{ $crumb['label'] }}
                                </a>
                            @else
                                <span class="text-white/90">{{ $crumb['label'] }}</span>
                            @endif
                            @if(!$loop->last)
                                <span class="text-white/40">/</span>
                            @endif
                        </li>
                    @endforeach
                </ol>
            </nav>
        @endif

        <h1 class="page-hero-title">{{ $title }}</h1>

        @if($subtitle)
            <p class="page-hero-subtitle">{{ $subtitle }}</p>
        @endif
    </div>
</section>
