@extends('layouts.app')

@section('title', 'Maintenance - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => 'Maintenance en cours',
        'subtitle' => 'Erreur 503',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Erreur 503']
        ]
    ])

    <div class="min-h-[50vh] flex items-center justify-center py-16">
        <div class="text-center px-4 max-w-lg">
            <div class="w-24 h-24 bg-amber-50 rounded-full flex items-center justify-center mx-auto mb-6">
                <i data-lucide="wrench" class="h-12 w-12 text-amber-300"></i>
            </div>
            <div class="text-7xl font-bold text-amber-100 mb-2 font-display">503</div>
            <p class="text-gray-500 mb-8">
                Le site est temporairement indisponible pour maintenance. Nous revenons très vite.
            </p>
            <a href="{{ route('home') }}" class="btn bg-primary text-white hover:bg-primary/90 gap-2">
                <i data-lucide="home" class="h-4 w-4"></i>
                Retour à l'accueil
            </a>
        </div>
    </div>
</div>
@endsection
