@extends('layouts.app')

@section('title', 'Erreur serveur - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => 'Erreur serveur',
        'subtitle' => 'Erreur 500',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Erreur 500']
        ]
    ])

    <div class="min-h-[50vh] flex items-center justify-center py-16">
        <div class="text-center px-4 max-w-lg">
            <div class="w-24 h-24 bg-red-50 rounded-full flex items-center justify-center mx-auto mb-6">
                <i data-lucide="alert-triangle" class="h-12 w-12 text-red-300"></i>
            </div>
            <div class="text-7xl font-bold text-red-100 mb-2 font-display">500</div>
            <p class="text-gray-500 mb-8">
                Une erreur interne est survenue. Veuillez réessayer dans quelques instants.
            </p>
            <div class="flex flex-col sm:flex-row gap-3 justify-center">
                <a href="{{ route('home') }}" class="btn bg-primary text-white hover:bg-primary/90 gap-2">
                    <i data-lucide="home" class="h-4 w-4"></i>
                    Retour à l'accueil
                </a>
                <a href="{{ route('products.index') }}" class="btn btn-outline gap-2">
                    Voir nos produits
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
