@extends('layouts.app')

@section('title', 'Page introuvable - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => 'Page introuvable',
        'subtitle' => 'Erreur 404',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Erreur 404']
        ]
    ])

    <div class="min-h-[50vh] flex items-center justify-center py-16">
        <div class="text-center px-4 max-w-lg">
            <div class="w-24 h-24 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-6">
                <i data-lucide="search-x" class="h-12 w-12 text-primary/40"></i>
            </div>
            <div class="text-7xl font-bold text-primary/15 mb-2 font-display">404</div>
            <p class="text-gray-500 mb-8">
                La page que vous recherchez n'existe pas ou a été déplacée.
            </p>
            <div class="flex flex-col sm:flex-row gap-3 justify-center">
                <a href="{{ route('home') }}" class="btn bg-primary text-white hover:bg-primary/90 gap-2">
                    <i data-lucide="home" class="h-4 w-4"></i>
                    Retour à l'accueil
                </a>
                <a href="{{ route('products.index') }}" class="btn btn-outline gap-2">
                    Voir nos produits
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
