<x-mail::message>
# Nouvelle Commande Reçue

Vous avez reçu une nouvelle commande sur JOLI Matelas.

## Détails de la commande

**Numéro de commande :** {{ $order->order_number }}
**Date :** {{ $order->created_at->format('d/m/Y à H:i') }}
**Statut :** {{ $order->status }}

## Client

**Nom :** {{ $order->customer_first_name }} {{ $order->customer_last_name }}
**Téléphone :** {{ $order->customer_phone }}
@if($order->customer_email)
**Email :** {{ $order->customer_email }}
@endif

## Adresse de livraison

{{ $order->delivery_street }}
{{ $order->delivery_postal_code }} {{ $order->delivery_city }}
{{ $order->delivery_country }}

## Articles commandés

<x-mail::table>
| Produit | Taille | Quantité | Prix unitaire | Sous-total |
|:--------|:-------|:--------:|:-------------:|:----------:|
@foreach($order->items as $item)
| {{ $item->product_name }} | {{ $item->variant_size }} | {{ $item->quantity }} | {{ number_format($item->unit_price, 2) }} € | {{ number_format($item->subtotal, 2) }} € |
@endforeach
</x-mail::table>

## Récapitulatif

**Sous-total :** {{ number_format($order->subtotal, 2) }} €
@if($order->tax_amount > 0)
**TVA :** {{ number_format($order->tax_amount, 2) }} €
@endif
@if($order->shipping_cost > 0)
**Frais de livraison :** {{ number_format($order->shipping_cost, 2) }} €
@endif
**Total :** {{ number_format($order->total_amount, 2) }} €

@if($order->customer_notes)
## Notes du client

{{ $order->customer_notes }}
@endif

<x-mail::button :url="config('app.url') . '/admin/orders/' . $order->id">
Voir la commande
</x-mail::button>

Merci,<br>
{{ config('app.name') }}
</x-mail::message>
