@extends('layouts.app')

@section('title', 'Contactez-nous - Jolis Matelas')

@push('styles')
<style>
    .contact-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 52%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .contact-page .page-header h1 {
        color: #003D82;
        text-align: center;
    }
    .contact-page .page-header p {
        color: #475569;
        text-align: center;
    }
    .contact-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .contact-page .page-header nav a {
        color: #64748b;
    }
    .contact-page .page-header nav span {
        color: #94a3b8;
    }
    .contact-page .page-header nav a:hover {
        color: #003D82;
    }
    .contact-page .contact-input {
        border: 1px solid #d1d5db;
        background-color: #ffffff;
    }
    .contact-page .contact-input::placeholder {
        color: #94a3b8;
    }
    .contact-page .contact-input:focus {
        border-color: #003D82;
        box-shadow: 0 0 0 3px rgba(0, 61, 130, 0.12);
    }
</style>
@endpush

@section('content')
<div class="min-h-screen bg-gray-50 contact-page">
    @include('partials.page-hero', [
        'title' => 'Contactez-nous',
        'subtitle' => 'Nous sommes à votre écoute',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Contact']
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12 space-y-8">
        @if(session('success'))
            <div class="rounded-xl border border-green-200 bg-green-50 p-4 text-sm text-green-700 flex items-center gap-2">
                <i data-lucide="check-circle" class="h-5 w-5 flex-shrink-0"></i>
                {{ session('success') }}
            </div>
        @endif

        @if($errors->any())
            <div class="rounded-xl border border-red-200 bg-red-50 p-4 text-sm text-red-700">
                <ul class="list-disc pl-4 space-y-1">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <section class="grid grid-cols-1 lg:grid-cols-3 gap-10">
            <div class="lg:col-span-1 space-y-6">
                <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
                    <h2 class="text-lg font-semibold text-primary mb-4 section-title">Coordonnées</h2>
                    <div class="space-y-3 text-sm text-gray-600">
                        <div class="flex items-center gap-3">
                            <i data-lucide="mail" class="h-4 w-4 text-accent flex-shrink-0"></i>
                            <a href="mailto:contact@jolismatelas.com" class="text-primary hover:underline">contact@jolismatelas.com</a>
                        </div>
                        <div class="flex items-center gap-3">
                            <i data-lucide="phone" class="h-4 w-4 text-accent flex-shrink-0"></i>
                            <span>Appelez le magasin le plus proche</span>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
                    <h2 class="text-lg font-semibold text-primary mb-4 section-title">Nos magasins</h2>
                    @if($stores->isEmpty())
                        <p class="text-sm text-gray-500 body-text">Aucun magasin actif pour le moment.</p>
                    @else
                        <div class="divide-y divide-gray-100 text-sm">
                            @foreach($stores as $store)
                                <div class="py-4 first:pt-0 last:pb-0">
                                    <div class="font-medium text-gray-900">{{ $store->name }}</div>
                                    <div class="text-gray-500">{{ $store->street }}, {{ $store->postal_code }} {{ $store->city }}</div>
                                    @if($store->phone)
                                        <div class="text-gray-500"><span class="font-medium text-gray-600">Téléphone :</span> {{ $store->phone }}</div>
                                    @endif
                                    @if($store->email)
                                        <div class="text-gray-500"><span class="font-medium text-gray-600">Email :</span> {{ $store->email }}</div>
                                    @endif
                                    @if($store->opening_hours)
                                        <div class="mt-2">
                                            <span class="font-medium text-gray-600">Horaires :</span>
                                            <div class="mt-1 space-y-0.5 text-gray-500">
                                                @foreach($store->opening_hours as $day => $hours)
                                                    <div>{{ $day }} : {{ $hours }}</div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            <div class="lg:col-span-2 bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
                <h2 class="text-lg font-semibold text-primary mb-6 section-title">Envoyer un message</h2>
                <form method="POST" action="{{ route('contact.store') }}" class="space-y-5 contact-form">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Nom <span class="text-red-500">*</span></label>
                            <input type="text" name="name" value="{{ old('name') }}" required class="input contact-input">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Téléphone</label>
                            <input type="text" name="phone" value="{{ old('phone') }}" class="input contact-input">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Email <span class="text-red-500">*</span></label>
                            <input type="email" name="email" value="{{ old('email') }}" required class="input contact-input">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Sujet <span class="text-red-500">*</span></label>
                            <input type="text" name="subject" value="{{ old('subject') }}" required class="input contact-input">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-2">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" rows="6" required class="textarea contact-input" placeholder="Votre message...">{{ old('message') }}</textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="btn btn-default btn-lg gap-2">
                            <i data-lucide="send" class="h-4 w-4"></i>
                            Envoyer
                        </button>
                    </div>
                </form>
            </div>
        </section>
    </div>
</div>
@endsection
