@extends('layouts.app')

@section('title', 'Panier - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => 'Mon panier',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Panier']
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">

        @if(empty($cart['items']))
            <div class="bg-white rounded-2xl shadow-sm p-12 text-center">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i data-lucide="shopping-cart" class="h-10 w-10 text-gray-300"></i>
                </div>
                <h2 class="text-xl font-semibold text-gray-900 mb-2">Votre panier est vide</h2>
                <p class="text-gray-500 mb-6">Découvrez nos produits de qualité</p>
                <a href="{{ route('products.index') }}" class="btn bg-primary text-white hover:bg-primary/90">
                    Voir nos produits
                </a>
            </div>
        @else
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8"
                 x-data="{
                    loading: {},
                    async updateQuantity(variantId, quantity) {
                        this.loading[variantId] = true;
                        const response = await fetch('{{ route('cart.update') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({ variant_id: variantId, quantity: quantity })
                        });
                        const data = await response.json();
                        this.loading[variantId] = false;
                        if (data.success) {
                            window.location.reload();
                        } else {
                            $dispatch('toast', { type: 'error', message: data.message });
                        }
                    },
                    async removeItem(variantId) {
                        this.loading[variantId] = true;
                        const response = await fetch('{{ route('cart.remove') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({ variant_id: variantId })
                        });
                        const data = await response.json();
                        if (data.success) {
                            window.location.reload();
                        } else {
                            $dispatch('toast', { type: 'error', message: data.message });
                        }
                    },
                    async clearCart() {
                        const response = await fetch('{{ route('cart.clear') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            }
                        });
                        window.location.reload();
                    }
                 }">
                <!-- Cart Items -->
                <div class="lg:col-span-2 space-y-4">
                    @foreach($cart['items'] as $item)
                    <div class="bg-white rounded-xl shadow-sm p-5 flex gap-4 items-center"
                         :class="loading[{{ $item['variant_id'] }}] ? 'opacity-50' : ''">
                        <!-- Product Image -->
                        <div class="w-20 h-20 flex-shrink-0 rounded-lg overflow-hidden bg-gray-100">
                            @if($item['product']->thumbnail)
                                <img src="{{ asset('storage/' . $item['product']->thumbnail) }}"
                                     alt="{{ $item['product']->name }}"
                                     class="w-full h-full object-cover">
                            @else
                                <div class="w-full h-full flex items-center justify-center">
                                    <i data-lucide="image" class="h-8 w-8 text-gray-300"></i>
                                </div>
                            @endif
                        </div>

                        <!-- Product Info -->
                        <div class="flex-1 min-w-0">
                            <h3 class="font-semibold text-gray-900 truncate">{{ $item['product']->name }}</h3>
                            <p class="text-sm text-gray-500">Taille : {{ $item['variant']->size }}</p>
                            <p class="text-base font-bold text-accent mt-1">{{ number_format($item['variant']->price, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</p>
                        </div>

                        <!-- Quantity Controls -->
                        <div class="flex items-center gap-2">
                            <button @click="updateQuantity({{ $item['variant_id'] }}, {{ $item['quantity'] - 1 }})"
                                    :disabled="loading[{{ $item['variant_id'] }}]"
                                    class="btn btn-sm btn-square btn-ghost rounded-lg">
                                <i data-lucide="minus" class="h-4 w-4"></i>
                            </button>
                            <span class="w-8 text-center font-medium text-gray-900">{{ $item['quantity'] }}</span>
                            <button @click="updateQuantity({{ $item['variant_id'] }}, {{ $item['quantity'] + 1 }})"
                                    :disabled="loading[{{ $item['variant_id'] }}]"
                                    class="btn btn-sm btn-square btn-ghost rounded-lg">
                                <i data-lucide="plus" class="h-4 w-4"></i>
                            </button>
                        </div>

                        <!-- Subtotal & Remove -->
                        <div class="flex flex-col items-end justify-between gap-2">
                            <span class="font-bold text-gray-900">{{ number_format($item['subtotal'], 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            <button @click="removeItem({{ $item['variant_id'] }})"
                                    class="text-red-400 hover:text-red-600 transition-colors p-1">
                                <i data-lucide="trash-2" class="h-4 w-4"></i>
                            </button>
                        </div>
                    </div>
                    @endforeach

                    <!-- Clear Cart -->
                    <div class="flex justify-end pt-2">
                        <button @click="if(confirm('Êtes-vous sûr de vouloir vider le panier ?')) clearCart()"
                                class="btn btn-ghost text-red-500 gap-2 text-sm">
                            <i data-lucide="trash" class="h-4 w-4"></i>
                            Vider le panier
                        </button>
                    </div>
                </div>

                <!-- Order Summary -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-xl shadow-sm p-6 sticky top-24">
                        <h2 class="text-lg font-bold text-primary mb-5">Récapitulatif</h2>

                        <div class="space-y-3 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-500">Articles ({{ $cart['total_items'] }})</span>
                                <span class="text-gray-900">{{ number_format($cart['total_price'], 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-500">Livraison</span>
                                <span class="text-green-600 font-medium">Gratuite</span>
                            </div>
                            <div class="border-t border-gray-100 pt-3 flex justify-between text-lg font-bold">
                                <span class="text-gray-900">Total</span>
                                <span class="text-accent">{{ number_format($cart['total_price'], 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            </div>
                        </div>

                        <div class="mt-6 space-y-3">
                            <a href="{{ route('checkout.index') }}"
                               class="btn w-full bg-accent hover:bg-accent/90 text-white gap-2 shadow-sm">
                                <i data-lucide="credit-card" class="h-4 w-4"></i>
                                Passer la commande
                            </a>
                            <a href="{{ route('products.index') }}" class="btn btn-outline w-full">
                                Continuer mes achats
                            </a>
                        </div>

                        <div class="mt-6 pt-4 border-t border-gray-100 space-y-2.5">
                            <div class="flex items-center gap-2 text-sm text-gray-500">
                                <i data-lucide="truck" class="h-4 w-4 text-green-500 flex-shrink-0"></i>
                                <span>Livraison gratuite</span>
                            </div>
                            <div class="flex items-center gap-2 text-sm text-gray-500">
                                <i data-lucide="banknote" class="h-4 w-4 text-green-500 flex-shrink-0"></i>
                                <span>Paiement à la livraison</span>
                            </div>
                            <div class="flex items-center gap-2 text-sm text-gray-500">
                                <i data-lucide="shield-check" class="h-4 w-4 text-green-500 flex-shrink-0"></i>
                                <span>Qualité garantie</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection
