﻿@extends('layouts.admin')

@section('title', 'Magasins')
@section('page-title', 'Magasins')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold">Liste des magasins</h2>
        <a href="{{ route('admin.stores.create') }}" class="inline-flex items-center px-3 py-2 rounded bg-primary text-white text-sm">Nouveau</a>
    </div>

    @if($stores->isEmpty())
        <p class="text-sm text-gray-600">Aucun magasin.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b">
                        <th class="py-2">Nom</th>
                        <th class="py-2">Ville</th>
                        <th class="py-2">Statut</th>
                        <th class="py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($stores as $store)
                    <tr class="border-b">
                        <td class="py-2">{{ $store->name }}</td>
                        <td class="py-2">{{ $store->city }}</td>
                        <td class="py-2">{{ $store->is_active ? 'Actif' : 'Inactif' }}</td>
                        <td class="py-2">
                            <a href="{{ route('admin.stores.edit', $store->id) }}" class="text-primary hover:underline">Modifier</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $stores->links() }}
        </div>
    @endif
</div>
@endsection
