﻿@extends('layouts.admin')

@section('title', 'Inventaire')
@section('page-title', 'Stock')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h2 class="text-lg font-semibold">Inventaire {{ $inventory->month }}</h2>
            <p class="text-sm text-gray-600">Magasin: {{ $inventory->store->name ?? '-' }}</p>
        </div>
        <div class="flex items-center gap-3">
            <a href="{{ route('admin.stock.inventories.export', $inventory->id) }}" class="px-3 py-2 text-sm border rounded-lg">Export CSV</a>
            <a href="{{ route('admin.stock.inventories.index') }}" class="text-sm text-gray-600 hover:text-primary">Retour</a>
        </div>
    </div>

    @if($errors->any())
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="p-3 bg-gray-50 rounded">
            <div class="text-xs text-gray-500">Statut</div>
            <div class="text-sm font-semibold">
                @if($inventory->status === 'VALIDE')
                    <span class="text-green-700">Valide</span>
                @else
                    <span class="text-amber-700">En cours</span>
                @endif
            </div>
        </div>
        <div class="p-3 bg-gray-50 rounded">
            <div class="text-xs text-gray-500">Mois</div>
            <div class="text-sm font-semibold">{{ $inventory->month }}</div>
        </div>
        <div class="p-3 bg-gray-50 rounded">
            <div class="text-xs text-gray-500">Validation</div>
            <div class="text-sm font-semibold">{{ $inventory->validated_at ? $inventory->validated_at->format('d/m/Y H:i') : '-' }}</div>
        </div>
        <div class="p-3 bg-gray-50 rounded">
            <div class="text-xs text-gray-500">Lignes</div>
            <div class="text-sm font-semibold">{{ $lines->count() }}</div>
        </div>
    </div>

    @if($lines->isEmpty())
        <p class="text-sm text-gray-600">Aucune ligne pour cet inventaire.</p>
    @else
        <form method="POST" action="{{ route('admin.stock.inventories.save', $inventory->id) }}">
            @csrf
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b bg-gray-50">
                            <th class="px-4 py-3 font-medium text-gray-600">Produit</th>
                            <th class="px-4 py-3 font-medium text-gray-600">Variante</th>
                            <th class="px-4 py-3 font-medium text-gray-600">Stock theorique</th>
                            <th class="px-4 py-3 font-medium text-gray-600">Stock reel</th>
                            <th class="px-4 py-3 font-medium text-gray-600">Ecart</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y">
                        @foreach($lines as $line)
                            @php
                                $realQtyInput = old('real_qty.' . $line->id, $line->real_qty);
                                $gapValue = $line->gap;
                                if ($gapValue === null && $realQtyInput !== null && $realQtyInput !== '') {
                                    $gapValue = (int)$realQtyInput - (int)$line->theoretical_qty;
                                }
                                $gapClass = $gapValue === null ? 'text-gray-500' : ($gapValue < 0 ? 'text-red-600' : ($gapValue > 0 ? 'text-green-600' : 'text-gray-700'));
                                $variantLabel = $line->variant->size ?? ($line->variant->name ?? '-');
                            @endphp
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 font-medium">{{ $line->product->name ?? '-' }}</td>
                                <td class="px-4 py-3">{{ $variantLabel }}</td>
                                <td class="px-4 py-3">{{ $line->theoretical_qty }}</td>
                                <td class="px-4 py-3">
                                    @if($inventory->status === 'EN_COURS')
                                        <input type="number" name="real_qty[{{ $line->id }}]" value="{{ $realQtyInput }}" min="0"
                                               class="w-28 rounded border border-gray-300 px-2 py-1 text-sm">
                                    @else
                                        {{ $line->real_qty ?? '-' }}
                                    @endif
                                </td>
                                <td class="px-4 py-3">
                                    <span class="font-semibold {{ $gapClass }}">{{ $gapValue === null ? '-' : $gapValue }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if($inventory->status === 'EN_COURS')
                <div class="flex items-center justify-end gap-3 mt-4">
                    <button type="submit" class="px-4 py-2 text-sm font-medium text-gray-700 border rounded-lg">Enregistrer</button>
                    <button type="submit" formaction="{{ route('admin.stock.inventories.validate', $inventory->id) }}"
                            class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90"
                            onclick="return confirm('Valider cet inventaire et appliquer les ajustements ?')">
                        Valider l'inventaire
                    </button>
                </div>
            @endif
        </form>
    @endif
</div>
@endsection
