﻿@extends('layouts.admin')

@section('title', 'Inventaires')
@section('page-title', 'Stock')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Inventaires</h2>
        <a href="{{ route('admin.stock.inventories.create') }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary text-white text-sm hover:bg-primary/90">
            <i data-lucide="plus" class="h-4 w-4"></i>
            Nouvel inventaire
        </a>
    </div>

    <form method="GET" action="{{ route('admin.stock.inventories.index') }}" class="mb-6">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
            <div>
                <label class="text-xs text-gray-600" for="filter_store_id">Magasin</label>
                <select id="filter_store_id" name="store_id" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous</option>
                    @foreach($stores as $store)
                        <option value="{{ $store->id }}" {{ (string)($currentFilters['store_id'] ?? '') === (string)$store->id ? 'selected' : '' }}>{{ $store->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="text-xs text-gray-600" for="filter_month">Mois</label>
                <input id="filter_month" type="month" name="month" value="{{ $currentFilters['month'] ?? '' }}" class="w-full border rounded px-2 py-2 text-sm">
            </div>
            <div>
                <label class="text-xs text-gray-600" for="filter_status">Statut</label>
                <select id="filter_status" name="status" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous</option>
                    <option value="EN_COURS" {{ ($currentFilters['status'] ?? '') === 'EN_COURS' ? 'selected' : '' }}>EN COURS</option>
                    <option value="VALIDE" {{ ($currentFilters['status'] ?? '') === 'VALIDE' ? 'selected' : '' }}>VALIDE</option>
                </select>
            </div>
            <div class="flex items-end gap-2">
                <button type="submit" class="inline-flex items-center px-3 py-2 rounded bg-gray-800 text-white text-sm">Filtrer</button>
                <a href="{{ route('admin.stock.inventories.index') }}" class="inline-flex items-center px-3 py-2 rounded border text-sm">Reinitialiser</a>
            </div>
        </div>
    </form>

    @if($inventories->isEmpty())
        <p class="text-sm text-gray-600">Aucun inventaire.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b bg-gray-50">
                        <th class="px-4 py-3 font-medium text-gray-600">Magasin</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Mois</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Statut</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Validation</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @foreach($inventories as $inventory)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 font-medium">{{ $inventory->store->name ?? '-' }}</td>
                            <td class="px-4 py-3">{{ $inventory->month }}</td>
                            <td class="px-4 py-3">
                                @if($inventory->status === 'VALIDE')
                                    <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-700">Valide</span>
                                @else
                                    <span class="px-2 py-1 text-xs rounded-full bg-amber-100 text-amber-700">En cours</span>
                                @endif
                            </td>
                            <td class="px-4 py-3">{{ $inventory->validated_at ? $inventory->validated_at->format('d/m/Y H:i') : '-' }}</td>
                            <td class="px-4 py-3">
                                <div class="flex items-center gap-3">
                                    <a href="{{ route('admin.stock.inventories.show', $inventory->id) }}" class="text-primary hover:underline text-sm">Voir</a>
                                    <a href="{{ route('admin.stock.inventories.export', $inventory->id) }}" class="text-gray-600 hover:underline text-sm">Export CSV</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $inventories->links() }}
        </div>
    @endif
</div>
@endsection
