@extends('layouts.admin')

@section('title', 'Modifier un service')
@section('page-title', 'Services connexes')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Modifier un service</h2>
        <a href="{{ route('admin.services.index') }}" class="text-sm text-gray-600 hover:text-primary">Retour</a>
    </div>

    @if($errors->any())
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.services.update', $service->id) }}" enctype="multipart/form-data" class="space-y-6">
        @csrf
        @method('PUT')

        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Titre *</label>
            <input type="text" name="title" value="{{ old('title', $service->title) }}" required
                   class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Description *</label>
            <textarea name="description" rows="5" required
                      class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm focus:ring-2 focus:ring-primary focus:border-transparent">{{ old('description', $service->description) }}</textarea>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Image (optionnelle)</label>
            @if($service->image)
                <div class="mb-2">
                    <img src="{{ asset('storage/' . $service->image) }}" alt="{{ $service->title }}" class="h-16 rounded">
                </div>
            @endif
            <input type="file" name="image" accept="image/*"
                   class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
        </div>

        <div class="flex items-center gap-3">
            <input type="checkbox" name="is_active" value="1" id="is_active"
                   {{ old('is_active', $service->is_active) ? 'checked' : '' }}
                   class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary">
            <label for="is_active" class="text-sm text-gray-700">Service actif</label>
        </div>

        <div class="flex items-center justify-end gap-3">
            <a href="{{ route('admin.services.index') }}"
               class="px-4 py-2 text-sm text-gray-600 hover:text-primary">Annuler</a>
            <button type="submit"
                    class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90">Enregistrer</button>
        </div>
    </form>
</div>
@endsection
