﻿@extends('layouts.admin')

@section('title', 'Promotions')
@section('page-title', 'Promotions')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold">Liste des promotions</h2>
        <a href="{{ route('admin.promotions.create') }}" class="inline-flex items-center px-3 py-2 rounded bg-primary text-white text-sm">Nouveau</a>
    </div>

    @if($promotions->isEmpty())
        <p class="text-sm text-gray-600">Aucune promotion.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b">
                        <th class="py-2">Image</th>
                        <th class="py-2">Titre</th>
                        <th class="py-2">Statut</th>
                        <th class="py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($promotions as $promo)
                    <tr class="border-b">
                        <td class="py-2">
                            @if($promo->image_path)
                                <img src="{{ asset('storage/' . $promo->image_path) }}" alt="{{ $promo->title }}" class="h-12 w-16 object-cover rounded">
                            @else
                                <span class="text-xs text-gray-500">-</span>
                            @endif
                        </td>
                        <td class="py-2 font-medium">{{ $promo->title }}</td>
                        <td class="py-2">
                            <form action="{{ route('admin.promotions.toggle', $promo->id) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit" class="px-2 py-1 text-xs rounded-full {{ $promo->is_active ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-600' }}">
                                    {{ $promo->is_active ? 'Active' : 'Inactive' }}
                                </button>
                            </form>
                        </td>
                        <td class="py-2">
                            <div class="flex items-center gap-3">
                                <a href="{{ route('admin.promotions.edit', $promo->id) }}" class="text-primary hover:underline">Modifier</a>
                                <form action="{{ route('admin.promotions.destroy', $promo->id) }}" method="POST" onsubmit="return confirm('Supprimer cette promotion ?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline">Supprimer</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $promotions->links() }}
        </div>
    @endif
</div>
@endsection
