@extends('layouts.admin')

@section('title', 'Nouvel attribut')
@section('page-title', 'Attributs produits')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Creer un attribut</h2>
        <a href="{{ route('admin.product-attributes.index') }}" class="text-sm text-gray-600 hover:text-primary">Retour</a>
    </div>

    @if($errors->any())
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.product-attributes.store') }}" class="space-y-6">
        @csrf

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Nom *</label>
                <input type="text" name="name" value="{{ old('name') }}" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                <select name="type" id="attribute_type" required
                        class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
                    <option value="text" {{ old('type') === 'text' ? 'selected' : '' }}>Texte</option>
                    <option value="number" {{ old('type') === 'number' ? 'selected' : '' }}>Nombre</option>
                    <option value="select" {{ old('type') === 'select' ? 'selected' : '' }}>Select</option>
                </select>
            </div>

            <div class="flex items-center gap-3">
                <input type="checkbox" name="required" value="1" id="required"
                       {{ old('required') ? 'checked' : '' }}
                       class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary">
                <label for="required" class="text-sm text-gray-700">Obligatoire</label>
            </div>

            <div id="options-wrapper">
                <label class="block text-sm font-medium text-gray-700 mb-2">Options (separees par des virgules)</label>
                <textarea name="options" rows="2"
                          class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm focus:ring-2 focus:ring-primary focus:border-transparent">{{ old('options') }}</textarea>
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Categories associees</label>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-2 text-sm text-gray-700">
                @foreach($categories as $category)
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="categories[]" value="{{ $category->id }}"
                               {{ in_array($category->id, old('categories', [])) ? 'checked' : '' }}
                               class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary">
                        {{ $category->name }}
                    </label>
                @endforeach
            </div>
        </div>

        <div class="flex items-center justify-end gap-3">
            <a href="{{ route('admin.product-attributes.index') }}"
               class="px-4 py-2 text-sm text-gray-600 hover:text-primary">Annuler</a>
            <button type="submit"
                    class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90">Creer</button>
        </div>
    </form>
</div>

<script>
    const typeSelect = document.getElementById('attribute_type');
    const optionsWrapper = document.getElementById('options-wrapper');

    const toggleOptions = () => {
        optionsWrapper.style.display = typeSelect.value === 'select' ? 'block' : 'none';
    };

    typeSelect.addEventListener('change', toggleOptions);
    toggleOptions();
</script>
@endsection
