# Guide de deploiement — JOLI Matelas (Laravel)

## Prerequis serveur

- PHP >= 8.1 avec extensions : BCMath, Ctype, Fileinfo, JSON, Mbstring, OpenSSL, PDO, Tokenizer, XML
- MySQL >= 8.0
- Composer
- Superviseur de processus (Supervisor, PM2, ou systemd) pour le queue worker

---

## 1. Variables d'environnement critiques

### APP_KEY

**Ne jamais deployer avec une cle connue ou committee.**

```bash
php artisan key:generate
```

Cette commande regenere `APP_KEY` dans `.env`. Elle est utilisee pour le chiffrement des cookies, sessions et donnees sensibles.

### APP_DEBUG

```env
APP_DEBUG=false
APP_ENV=production
```

**En production, `APP_DEBUG` doit toujours etre `false`.** Sinon, les stack traces, variables d'environnement et chemins du serveur sont exposes aux visiteurs.

### APP_URL

```env
APP_URL=https://www.jolimatelas.com
```

Adapter au domaine reel de production.

---

## 2. Configuration MAIL (production)

En local, le projet utilise Mailpit (port 1025) pour intercepter les emails. **En production, configurer un vrai serveur SMTP.**

### Exemple avec un SMTP standard (Brevo, Mailgun, OVH, SES)

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.votre-provider.com
MAIL_PORT=587
MAIL_USERNAME=votre-user@provider.com
MAIL_PASSWORD=votre-mot-de-passe-smtp
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="contact@jolimatelas.com"
MAIL_FROM_NAME="Boutique Matelas"
```

### Emails envoyes par l'application

| Mailable | Declencheur | Description |
|----------|------------|-------------|
| `NewOrderNotification` | Nouvelle commande | Notifie les admins |
| `LowStockAlert` | Stock critique | Alerte stock bas |
| `VerificationCodeMail` | Inscription API | Code de verification |
| `AccountActivatedMail` | Activation compte | Confirmation activation |

Tous les Mailables implementent `ShouldQueue` : ils sont dispatches en queue, pas en synchrone.

---

## 3. Configuration QUEUE (production)

### Pourquoi

Les emails ne doivent pas bloquer les requetes HTTP (checkout, admin). Le driver `database` stocke les jobs dans une table MySQL.

### Configuration

```env
QUEUE_CONNECTION=database
```

### Migrations necessaires

```bash
php artisan migrate
```

Les tables `jobs` et `failed_jobs` seront creees automatiquement.

### Lancer le worker

```bash
php artisan queue:work --sleep=3 --tries=3 --max-time=3600
```

### Supervision (Supervisor — Linux)

Fichier `/etc/supervisor/conf.d/joli-worker.conf` :

```ini
[program:joli-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /chemin/vers/artisan queue:work database --sleep=3 --tries=3 --max-time=3600
autostart=true
autorestart=true
stopasgroup=true
killasgroup=true
user=www-data
numprocs=2
redirect_stderr=true
stdout_logfile=/var/log/joli-worker.log
stopwaitsecs=3600
```

Puis :

```bash
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start joli-worker:*
```

### Supervision (Windows — Task Scheduler)

Creer une tache planifiee qui execute :

```
php C:\chemin\vers\artisan queue:work database --sleep=3 --tries=3 --max-time=3600
```

Configurer le redemarrage automatique en cas d'arret.

### Surveillance des jobs echoues

```bash
# Lister les jobs echoues
php artisan queue:failed

# Relancer un job echoue
php artisan queue:retry {id}

# Relancer tous les jobs echoues
php artisan queue:retry all

# Vider les jobs echoues
php artisan queue:flush
```

---

## 4. Securite — Page de confirmation commande

La page de confirmation de commande publique utilise un **UUID** non devinable (`/commande/confirmation/{uuid}`) au lieu du numero de commande sequentiel (`CMD-YYYY-00001`).

- Le `order_number` reste visible dans la vue comme reference humaine.
- L'UUID est genere automatiquement a la creation de chaque commande.
- Un UUID invalide retourne une erreur 404 standard.
- L'admin continue d'utiliser l'ID interne (`/admin/orders/{id}`).

---

## 5. Scheduler Laravel (cron)

Le projet utilise le scheduler Laravel pour des taches periodiques :

| Commande | Frequence | Description |
|----------|-----------|-------------|
| `stock:cleanup-reservations` | Toutes les 5 minutes | Nettoie les reservations Redis expirees |

### Configuration serveur (Linux)

Ajouter au crontab :

```
* * * * * cd /chemin/vers/projet && php artisan schedule:run >> /dev/null 2>&1
```

### Configuration (Windows)

Creer une tache planifiee qui execute toutes les minutes :

```
php C:\chemin\vers\artisan schedule:run
```

### Test manuel

```bash
php artisan stock:cleanup-reservations
```

---

## 6. Checklist de deploiement

```
[ ] Copier .env.example vers .env
[ ] php artisan key:generate
[ ] Configurer DB_* (host, database, username, password)
[ ] APP_ENV=production, APP_DEBUG=false
[ ] Configurer MAIL_* (SMTP reel)
[ ] QUEUE_CONNECTION=database
[ ] php artisan migrate --force
[ ] php artisan config:cache
[ ] php artisan route:cache
[ ] php artisan view:cache
[ ] php artisan storage:link
[ ] Lancer le queue worker (Supervisor / systemd / Task Scheduler)
[ ] Configurer le cron Laravel (scheduler) pour les taches periodiques
[ ] Verifier que les emails partent (passer une commande test)
[ ] Verifier que /commande/confirmation/{uuid-invalide} retourne 404
```

---

## 7. Commandes utiles post-deploiement

```bash
# Vider les caches
php artisan optimize:clear

# Reconstruire les caches
php artisan optimize

# Verifier les routes
php artisan route:list

# Verifier les migrations en attente
php artisan migrate:status

# Relancer le worker apres un deploiement
php artisan queue:restart
```
