<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $driver = DB::getDriverName();

        if ($driver === 'mysql') {
            DB::statement('ALTER TABLE stores MODIFY postal_code VARCHAR(20) NULL');
            return;
        }

        if ($driver === 'pgsql') {
            DB::statement('ALTER TABLE stores ALTER COLUMN postal_code DROP NOT NULL');
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $driver = DB::getDriverName();

        if ($driver === 'mysql') {
            DB::statement('ALTER TABLE stores MODIFY postal_code VARCHAR(20) NOT NULL');
            return;
        }

        if ($driver === 'pgsql') {
            DB::statement('ALTER TABLE stores ALTER COLUMN postal_code SET NOT NULL');
        }
    }
};
