<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->foreignId('fulfillment_source_id')
                ->nullable()
                ->after('admin_notes')
                ->constrained('fulfillment_sources')
                ->nullOnDelete();
            $table->text('fulfillment_note')->nullable()->after('fulfillment_source_id');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropConstrainedForeignId('fulfillment_source_id');
            $table->dropColumn('fulfillment_note');
        });
    }
};
