<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fulfillment_sources', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', ['STORE', 'FACTORY', 'PARTNER', 'WAREHOUSE'])->default('WAREHOUSE');
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fulfillment_sources');
    }
};
