<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Reset reserved_quantity for existing orders
     * Cette migration est nécessaire car l'ancien système décrémentait quantity directement
     */
    public function up(): void
    {
        // Étape 1: Réinitialiser tous les reserved_quantity à 0
        DB::table('stock_items')->update(['reserved_quantity' => 0]);

        // Étape 2: Calculer les réservations pour les commandes EN_ATTENTE_*
        $orders = DB::table('orders')
            ->whereIn('status', ['EN_ATTENTE_TRAITEMENT', 'EN_ATTENTE_LIVRAISON'])
            ->get();

        foreach ($orders as $order) {
            $orderItems = DB::table('order_items')
                ->where('order_id', $order->id)
                ->get();

            foreach ($orderItems as $item) {
                // Incrémenter reserved_quantity pour chaque item de commande en cours
                DB::table('stock_items')
                    ->where('product_id', $item->product_id)
                    ->where('variant_id', $item->variant_id)
                    ->where('store_id', $order->store_id)
                    ->increment('reserved_quantity', $item->quantity);
            }
        }

        // Étape 3: Log des résultats
        $totalReserved = DB::table('stock_items')->sum('reserved_quantity');
        Log::info("Migration reserved_quantity: {$totalReserved} unités réservées pour " . count($orders) . " commandes");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reset reserved_quantity
        DB::table('stock_items')->update(['reserved_quantity' => 0]);
    }
};
