<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // ÉTAPE 1: Ajouter les nouvelles valeurs à l'ENUM (garder les anciennes temporairement)
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED',
            'EN_ATTENTE_TRAITEMENT',
            'EN_ATTENTE_LIVRAISON',
            'LIVREE',
            'ANNULEE'
        ) DEFAULT 'PENDING'");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN old_status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED',
            'EN_ATTENTE_TRAITEMENT',
            'EN_ATTENTE_LIVRAISON',
            'LIVREE',
            'ANNULEE'
        ) NULL");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN new_status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED',
            'EN_ATTENTE_TRAITEMENT',
            'EN_ATTENTE_LIVRAISON',
            'LIVREE',
            'ANNULEE'
        )");

        // ÉTAPE 2: Mapper les anciennes valeurs vers les nouvelles (données existantes)
        // PENDING → EN_ATTENTE_TRAITEMENT
        DB::statement("UPDATE orders SET status = 'EN_ATTENTE_TRAITEMENT' WHERE status = 'PENDING'");
        DB::statement("UPDATE order_status_histories SET old_status = 'EN_ATTENTE_TRAITEMENT' WHERE old_status = 'PENDING'");
        DB::statement("UPDATE order_status_histories SET new_status = 'EN_ATTENTE_TRAITEMENT' WHERE new_status = 'PENDING'");

        // CONFIRMED, PREPARING, READY → EN_ATTENTE_LIVRAISON
        DB::statement("UPDATE orders SET status = 'EN_ATTENTE_LIVRAISON' WHERE status IN ('CONFIRMED', 'PREPARING', 'READY')");
        DB::statement("UPDATE order_status_histories SET old_status = 'EN_ATTENTE_LIVRAISON' WHERE old_status IN ('CONFIRMED', 'PREPARING', 'READY')");
        DB::statement("UPDATE order_status_histories SET new_status = 'EN_ATTENTE_LIVRAISON' WHERE new_status IN ('CONFIRMED', 'PREPARING', 'READY')");

        // DELIVERED → LIVREE
        DB::statement("UPDATE orders SET status = 'LIVREE' WHERE status = 'DELIVERED'");
        DB::statement("UPDATE order_status_histories SET old_status = 'LIVREE' WHERE old_status = 'DELIVERED'");
        DB::statement("UPDATE order_status_histories SET new_status = 'LIVREE' WHERE new_status = 'DELIVERED'");

        // CANCELLED → ANNULEE
        DB::statement("UPDATE orders SET status = 'ANNULEE' WHERE status = 'CANCELLED'");
        DB::statement("UPDATE order_status_histories SET old_status = 'ANNULEE' WHERE old_status = 'CANCELLED'");
        DB::statement("UPDATE order_status_histories SET new_status = 'ANNULEE' WHERE new_status = 'CANCELLED'");

        // ÉTAPE 3: Retirer les anciennes valeurs de l'ENUM
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM(
            'EN_ATTENTE_TRAITEMENT',
            'EN_ATTENTE_LIVRAISON',
            'LIVREE',
            'ANNULEE'
        ) DEFAULT 'EN_ATTENTE_TRAITEMENT'");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN old_status ENUM(
            'EN_ATTENTE_TRAITEMENT',
            'EN_ATTENTE_LIVRAISON',
            'LIVREE',
            'ANNULEE'
        ) NULL");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN new_status ENUM(
            'EN_ATTENTE_TRAITEMENT',
            'EN_ATTENTE_LIVRAISON',
            'LIVREE',
            'ANNULEE'
        )");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revenir aux 6 valeurs précédentes
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED'
        ) DEFAULT 'PENDING'");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN old_status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED'
        ) NULL");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN new_status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED'
        )");

        // Mapper retour (inverse)
        DB::statement("UPDATE orders SET status = 'PENDING' WHERE status = 'EN_ATTENTE_TRAITEMENT'");
        DB::statement("UPDATE orders SET status = 'CONFIRMED' WHERE status = 'EN_ATTENTE_LIVRAISON'");
        DB::statement("UPDATE orders SET status = 'DELIVERED' WHERE status = 'LIVREE'");
        DB::statement("UPDATE orders SET status = 'CANCELLED' WHERE status = 'ANNULEE'");

        DB::statement("UPDATE order_status_histories SET old_status = 'PENDING' WHERE old_status = 'EN_ATTENTE_TRAITEMENT'");
        DB::statement("UPDATE order_status_histories SET old_status = 'CONFIRMED' WHERE old_status = 'EN_ATTENTE_LIVRAISON'");
        DB::statement("UPDATE order_status_histories SET old_status = 'DELIVERED' WHERE old_status = 'LIVREE'");
        DB::statement("UPDATE order_status_histories SET old_status = 'CANCELLED' WHERE old_status = 'ANNULEE'");

        DB::statement("UPDATE order_status_histories SET new_status = 'PENDING' WHERE new_status = 'EN_ATTENTE_TRAITEMENT'");
        DB::statement("UPDATE order_status_histories SET new_status = 'CONFIRMED' WHERE new_status = 'EN_ATTENTE_LIVRAISON'");
        DB::statement("UPDATE order_status_histories SET new_status = 'DELIVERED' WHERE new_status = 'LIVREE'");
        DB::statement("UPDATE order_status_histories SET new_status = 'CANCELLED' WHERE new_status = 'ANNULEE'");
    }
};
