<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Modifier l'enum pour inclure les nouveaux statuts utilisés par le controller
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED'
        ) DEFAULT 'PENDING'");

        // Mettre à jour également la table order_status_histories (old_status et new_status)
        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN old_status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED'
        ) NULL");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN new_status ENUM(
            'PENDING',
            'CONFIRMED',
            'PREPARING',
            'READY',
            'DELIVERED',
            'CANCELLED'
        )");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revenir aux anciennes valeurs
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM(
            'PENDING',
            'PROCESSING',
            'SHIPPING',
            'DELIVERED',
            'CANCELLED'
        ) DEFAULT 'PENDING'");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN old_status ENUM(
            'PENDING',
            'PROCESSING',
            'SHIPPING',
            'DELIVERED',
            'CANCELLED'
        ) NULL");

        DB::statement("ALTER TABLE order_status_histories MODIFY COLUMN new_status ENUM(
            'PENDING',
            'PROCESSING',
            'SHIPPING',
            'DELIVERED',
            'CANCELLED'
        )");
    }
};
