<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();

            $table->string('order_number', 50)->unique(); // Ex: "CMD-2024-00123"

            // Client (NULL si commande sans compte)
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');

            // Informations client (même si user existe)
            $table->string('customer_first_name');
            $table->string('customer_last_name');
            $table->string('customer_phone', 20);
            $table->string('customer_email')->nullable();

            // Adresse de livraison
            $table->string('delivery_street');
            $table->string('delivery_city');
            $table->string('delivery_postal_code', 20);
            $table->string('delivery_country')->default('France');

            // Magasin assigné
            $table->foreignId('store_id')->constrained()->onDelete('restrict');

            // Montants
            $table->decimal('subtotal', 10, 2);
            $table->decimal('tax_amount', 10, 2)->default(0);
            $table->decimal('shipping_cost', 10, 2)->default(0);
            $table->decimal('total_amount', 10, 2);

            // Statut
            $table->enum('status', ['PENDING', 'PROCESSING', 'SHIPPING', 'DELIVERED', 'CANCELLED'])->default('PENDING');
            $table->enum('payment_method', ['CASH_ON_DELIVERY'])->default('CASH_ON_DELIVERY');
            $table->boolean('is_paid')->default(false);

            // Notes
            $table->text('customer_notes')->nullable();
            $table->text('admin_notes')->nullable();

            // Dates
            $table->timestamps();
            $table->timestamp('delivered_at')->nullable();

            // Index
            $table->index('order_number');
            $table->index('user_id');
            $table->index('store_id');
            $table->index('status');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
