<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_movements', function (Blueprint $table) {
            $table->id();

            $table->foreignId('stock_item_id')->constrained()->onDelete('cascade');

            $table->enum('type', ['IN', 'OUT', 'ADJUSTMENT', 'TRANSFER']);
            $table->integer('quantity'); // Positif = entrée, négatif = sortie
            $table->string('reason')->nullable();

            // Pour les transferts entre magasins
            $table->foreignId('from_store_id')->nullable()->constrained('stores')->onDelete('set null');
            $table->foreignId('to_store_id')->nullable()->constrained('stores')->onDelete('set null');

            // Qui a effectué le mouvement (admin user_id)
            $table->foreignId('performed_by')->nullable()->constrained('users')->onDelete('set null');

            $table->timestamp('created_at')->useCurrent();

            // Index
            $table->index('stock_item_id');
            $table->index('created_at');
            $table->index('type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_movements');
    }
};
