<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_items', function (Blueprint $table) {
            $table->id();

            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('variant_id')->constrained('product_variants')->onDelete('cascade');
            $table->foreignId('store_id')->constrained()->onDelete('cascade');

            $table->integer('quantity')->default(0);
            $table->integer('reserved_quantity')->default(0)->comment('Quantité réservée pour commandes en cours');
            $table->integer('alert_threshold')->default(5)->comment('Alerte si stock < seuil');

            $table->timestamps();

            // Contrainte: UN SEUL stock par produit/variante/magasin
            $table->unique(['product_id', 'variant_id', 'store_id'], 'stock_unique');

            // Index
            $table->index('store_id');
            $table->index('quantity');
            $table->index(['product_id', 'variant_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_items');
    }
};
