<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stores', function (Blueprint $table) {
            $table->id();

            $table->string('name');
            $table->text('description')->nullable();

            // Adresse
            $table->string('street');
            $table->string('city');
            $table->string('postal_code', 20);
            $table->string('country')->default('France');

            // Contact
            $table->string('phone', 20);
            $table->string('email');

            // Coordonnées GPS
            $table->decimal('latitude', 10, 7)->nullable();
            $table->decimal('longitude', 10, 7)->nullable();

            // Horaires (JSON)
            $table->json('opening_hours')->nullable();

            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // Index
            $table->index('is_active');
            $table->index('city');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stores');
    }
};
