<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');

            // Taille (ex: "90x190", "140x190", "160x200")
            $table->string('size', 50);

            // Prix spécifique à cette taille
            $table->decimal('price', 10, 2);

            // SKU (Stock Keeping Unit) - Code unique
            $table->string('sku', 100)->unique();

            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // Index
            $table->index('product_id');
            $table->index('sku');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_variants');
    }
};
