<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description');
            $table->string('short_desc', 500)->nullable();
            $table->decimal('base_price', 10, 2);

            // Caractéristiques matelas
            $table->enum('type', ['FOAM', 'SPRING', 'MEMORY_FOAM', 'LATEX', 'HYBRID'])->nullable();
            $table->enum('firmness', ['SOFT', 'MEDIUM', 'FIRM', 'EXTRA_FIRM'])->nullable();
            $table->integer('height')->nullable()->comment('Hauteur en cm');
            $table->string('material')->nullable()->comment('Composition');
            $table->integer('warranty')->nullable()->comment('Garantie en années');

            // SEO
            $table->string('meta_title')->nullable();
            $table->string('meta_desc')->nullable();

            // Médias (JSON array of image URLs)
            $table->json('images')->nullable();
            $table->string('thumbnail')->nullable();

            // Statut
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);

            // Catégorie
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');

            $table->timestamps();

            // Index
            $table->index('slug');
            $table->index('category_id');
            $table->index(['is_active', 'is_featured']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
