<?php

namespace App\Providers;

use App\Services\MailSettingsService;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Queue;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);
        MailSettingsService::apply();

        Queue::before(function () {
            MailSettingsService::apply();
        });
    }
}
