<?php

namespace App\Exceptions;

use Exception;

class StockReservationException extends Exception
{
    protected $code = 500;
    protected $message = 'Erreur lors de la réservation du stock';

    /**
     * Report the exception.
     */
    public function report(): void
    {
        // Log l'exception
        \Log::error('Stock Reservation Error: ' . $this->getMessage());
    }

    /**
     * Render the exception as an HTTP response.
     */
    public function render($request)
    {
        return response()->json([
            'error' => 'Erreur de réservation',
            'message' => $this->getMessage(),
        ], $this->code);
    }
}
