<?php

namespace App\Exceptions;

use Exception;

class InsufficientStockException extends Exception
{
    protected $code = 400;
    protected $message = 'Stock insuffisant pour cette demande';

    /**
     * Report the exception.
     */
    public function report(): void
    {
        // Log l'exception si nécessaire
    }

    /**
     * Render the exception as an HTTP response.
     */
    public function render($request)
    {
        return response()->json([
            'error' => 'Stock insuffisant',
            'message' => $this->getMessage(),
        ], $this->code);
    }
}
