<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class MakeAdminUser extends Command
{
    protected $signature = 'make:admin-user
                            {email? : Email de l\'administrateur}
                            {password? : Mot de passe}';

    protected $description = 'Créer un compte administrateur';

    public function handle(): int
    {
        $email = $this->argument('email') ?? $this->ask('Email de l\'administrateur');
        $password = $this->argument('password') ?? $this->secret('Mot de passe');

        $existing = User::where('email', $email)->first();

        if ($existing) {
            if (!$this->confirm("L'utilisateur {$email} existe déjà. Mettre à jour en admin ?")) {
                return Command::FAILURE;
            }

            $existing->update([
                'password' => Hash::make($password),
                'role' => 'ADMIN',
                'is_active' => true,
            ]);

            $this->info("Utilisateur {$email} mis à jour en ADMIN.");
            return Command::SUCCESS;
        }

        User::create([
            'first_name' => 'Admin',
            'last_name' => 'JOLI',
            'email' => $email,
            'password' => Hash::make($password),
            'role' => 'ADMIN',
            'is_active' => true,
        ]);

        $this->info("Administrateur {$email} créé avec succès.");
        return Command::SUCCESS;
    }
}
