<?php

namespace App\Console\Commands;

use App\Models\Product;
use App\Models\ProductVariant;
use Illuminate\Console\Command;

class FixMissingVariants extends Command
{
    protected $signature = 'fix:missing-variants';
    protected $description = 'Create a default variant for active products that have none';

    public function handle(): int
    {
        $products = Product::where('is_active', true)
            ->whereDoesntHave('variants')
            ->get();

        if ($products->isEmpty()) {
            $this->info('All active products already have at least one variant.');
            return 0;
        }

        foreach ($products as $product) {
            $variant = ProductVariant::create([
                'product_id' => $product->id,
                'size' => 'Standard',
                'price' => $product->base_price,
                'is_active' => true,
            ]);

            $this->info("Created variant for '{$product->name}' (product #{$product->id}) → variant #{$variant->id}, size=Standard, price={$product->base_price}, sku={$variant->sku}");
        }

        $this->info("Done. {$products->count()} variant(s) created.");
        return 0;
    }
}
