<?php

namespace App\Console\Commands;

use App\Services\StockService;
use Illuminate\Console\Command;

class CleanupStockReservations extends Command
{
    protected $signature = 'stock:cleanup-reservations';

    protected $description = 'Nettoyer les réservations de stock Redis expirées';

    public function handle(StockService $stockService): int
    {
        $cleaned = $stockService->cleanupExpiredReservations();

        $this->info("Réservations expirées nettoyées : {$cleaned}");

        return Command::SUCCESS;
    }
}
